<?php

namespace ReneSeindal;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class PluginBaseMustUse extends PluginBase {
    protected $plugin_file = __DIR__ . '/rs-base-plugin.php';

    function do_plugin_action_links___PLUGIN_BASENAME___action( $links ) {
        $muplugins = get_mu_plugins();
        $key = basename( $this->plugin_file );

        if ( array_key_exists( $key, $muplugins ) ) {
            $text = __( 'Remove must-use plugin', 'rs-base-plugin' );
            $action = 'rsbp_disable_mustuse';
        } else {
            $text = __( 'Install must-use plugin', 'rs-base-plugin' );
            $action = 'rsbp_install_mustuse';
        }
        $url = $this->build_admin_url( 'admin-post.php', [
            'action' => $action,
            '_wpnonce' => wp_create_nonce( "$action-nonce" ),
            'return' => urlencode( site_url( $_SERVER['REQUEST_URI'] ) ),
        ] );

        $links[] = sprintf( '<a href="%s">%s</a>', esc_url( $url ), esc_html( $text ) );
        return $links;
    }

    function do_admin_post_rsbp_disable_mustuse_action() {
        if ( !( isset( $_REQUEST['_wpnonce'] ) && wp_verify_nonce( $_REQUEST['_wpnonce'], 'rsbp_disable_mustuse-nonce' ) ) )
            die( __( 'Security check', 'rs-base-plugin' ) );

        $basename = basename( $this->plugin_file, '.php');
        @unlink( WPMU_PLUGIN_DIR . "/$basename.php" );

        $return = urldecode( $_GET['return'] );
        wp_redirect( $return );
        exit;
    }

    function do_admin_post_rsbp_install_mustuse_action() {
        if ( !( isset( $_REQUEST['_wpnonce'] ) && wp_verify_nonce( $_REQUEST['_wpnonce'], 'rsbp_install_mustuse-nonce' ) ) )
            die( __( 'Security check', 'rs-base-plugin' ) );

        if ( ! is_dir( WPMU_PLUGIN_DIR ) )
            @mkdir( WPMU_PLUGIN_DIR, 0755 );

        if ( is_dir( WPMU_PLUGIN_DIR ) ) {
            $basename = basename( $this->plugin_file, '.php');

            $link = WPMU_PLUGIN_DIR . "/$basename.php";
            $target = "../plugins/$basename/$basename.php";

            if ( is_file( $link ) )
                unlink( $link );
            elseif ( is_link( $link ) ) {
                $old = readlink( $link );
                if ( $old != $target )
                    unlink( $link );
            }

            if ( ! file_exists( $link ) )
                symlink( $target, $link );
        }

        $return = urldecode( $_GET['return'] );
        wp_redirect( $return );
        exit;
    }
}

add_action( 'plugins_loaded', function() {
    PluginBaseMustUse::instance();
} );
