<?php

namespace ReneSeindal;

/**
 * RS Base Plugin
 *
 * ## EXAMPLES
 *
 *     wp rsbp status
 *     wp rsbp on
 *     wp rsbp off
 *
 * @when after_wp_load
 */

if ( ! defined( 'ABSPATH' ) && ! defined( 'WP_CLI' ) ) exit; // Exit if accessed directly

class RSBasePluginCLI {

    public function status( $args, $assoc ) {
        $basename = 'rs-base-plugin'; // basename( __FILE__, '.php');

        $mu_plugins = get_mu_plugins();
        $mu = NULL;
        if ( isset( $mu_plugins[ "$basename.php" ] ) )
            $mu = $mu_plugins[ "$basename.php" ];

        $my_v = $mu ? $mu[ 'Version' ] : NULL;

        $plugins = get_plugins();
        $plugin = NULL;
        if ( isset( $plugins[ "$basename/$basename.php" ] ) )
            $plugin = $plugins[ "$basename/$basename.php" ];

        $pl_v = $plugin ? $plugin[ 'Version' ] : NULL;

        // Show status

        \WP_CLI::line( sprintf( "Must-use plugin is version %s; normal plugin is version %s.",
                                $mu ? $mu['Version'] : '<not installed>',
                                $plugin ? $plugin['Version'] : '<not installed>'
        ) );
    }

    /**
     * Install must-use plugin
     *
     * ## EXAMPLES
     *
     *     wp rsbp on
     *
     */

    public function on( $args, $assoc ) {
        $basename = basename( __FILE__, '.php');

        // Activate must-use plugin

        if ( ! is_dir( WPMU_PLUGIN_DIR ) ) {
            if ( ! mkdir( WPMU_PLUGIN_DIR, 0755 ) ) {
                \WP_CLI::error( "Failed to create must-use plugin directory " . WPMU_PLUGIN_DIR );
            }
        }
        if ( is_dir( WPMU_PLUGIN_DIR ) ) {
            $link = WPMU_PLUGIN_DIR . "/$basename.php";
            $target = "../plugins/$basename/$basename.php";

            if ( is_file( $link ) )
                unlink( $link );
            elseif ( is_link( $link ) ) {
                $old = readlink( $link );
                if ( $old != $target )
                    unlink( $link );
            }

            if ( ! file_exists( $link ) )
                symlink( $target, $link );
        }
    }

    /**
     * Uninstall must-use plugin
     *
     * ## EXAMPLES
     *
     *     wp rsbp must-use off
     *
     */

    public function off( $args, $assoc ) {
        $basename = basename( __FILE__, '.php');
        @unlink( WPMU_PLUGIN_DIR . "/$basename.php" );
    }
}

\WP_CLI::add_command( 'rsbp', new RSBasePluginCLI() );
