<?php
/**
 * Plugin Name:         RS Base Plugin
 * Description:         A really simple class based plugin framework
 * Plugin URI:          https://plugins.seindal.dk/plugins/rs-base-plugin/
 * Update URI:          https://plugins.seindal.dk
 * Author:              René Seindal
 * Author URI:          https://plugins.seindal.dk/
 * Donate link:         https://mypos.com/@historywalks
 * License:             GPL v2 or later
 * License URI:         https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:         rs-base-plugin
 * Domain Path:         /languages
 * Requires PHP:        7.4
 * Requires at least:   5.0
 * Version:             1.18.1
 **/

namespace ReneSeindal;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

if ( ! class_exists( __NAMESPACE__ . '\PluginBase' ) ) {
    include( __DIR__ . '/class-plugin-base.php' );
    include( __DIR__ . '/class-must-use.php' );

    include( __DIR__ . '/trait-custom-login-page.php' );
    include( __DIR__ . '/trait-settings.php' );

    include( __DIR__ . '/trait-html-comment-redirect.php' );
    include( __DIR__ . '/trait-footnote-link-popups.php' );
    include( __DIR__ . '/trait-notify-owner-scheduled-publish.php' );

    include( __DIR__ . '/trait-gutenberg-no-remote.php' );
    include( __DIR__ . '/trait-yoast-seo.php' );
}

if ( defined( 'WP_CLI' ) && WP_CLI ) {
    require_once dirname( __FILE__ ) . '/rs-base-plugin-cli.php';
}
