<?php

namespace ReneSeindal;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


/************************************************************************
 *
 * Add footnotes as title attribute
 *
 ************************************************************************/

trait PluginFootnoteLinkPopups {
    function do_the_content_filter_footnote_link_popups( $content ) {
        if ( !( is_singular() && in_the_loop() && is_main_query() ))
            return $content;

        $post = get_post();
        if ( empty( $post ) )
            return $content;

        return $this->trait_footnotes_link_popup_worker( $post, $content );
    }

    function trait_footnotes_link_popup_worker( $post, $content = NULL ) {
        $ellipsis = '&nbsp;&hellip;';
        $max_length = 512 - strlen( $ellipsis );

        $json = $post->footnotes;
        if ( empty( $json ) )
            return $content;

        try {
            $data = json_decode( $json, true );
        } catch ( ValueException ) {
            return $content;
        }

        $footnotes = [];
        foreach ( $data as $fn ) {
            $text = trim( strip_tags( do_shortcode( $fn['content'] ) ) );
            if ( strlen( $text ) > $max_length ) {
                $words = str_word_count( $text, 2 );
                foreach ( $words as $offset => $word )
                    if ( $offset > $max_length )
                        unset( $words[$offset] );
                $text = join( ' ', $words ) . $ellipsis;
            }
            $footnotes[$fn['id']] = $text;
        }

        if ( empty( $content ) )
            $content = $post->post_content;

        $parser = new \WP_HTML_TAG_Processor( $content );
        while ( $parser->next_tag( [ 'tag_name' => 'sup', 'class_name' => 'fn' ] ) ) {
            $id = $parser->get_attribute( 'data-fn' );
            if ( !empty( $id ) && array_key_exists( $id, $footnotes ) && !empty(  $footnotes[$id] ) )
                $parser->set_attribute( 'title', $footnotes[$id] );
        }

        return $parser->get_updated_html();
    }
}
