<?php

namespace ReneSeindal;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


/************************************************************************
 *
 *  Allow redirects through HTML block comments
 *
 *  Content of post should contain a HTML comment <!-- -->
 *  with either the URL to redirect to, or simply the numeric
 *  ID of a post to redirect to.
 *
 ************************************************************************/

trait PluginHTMLCommentRedirect {
    function do_template_redirect_action_trait_html_comment_redirect() {
        if ( ! is_singular() )
            return;
        $post = get_post();

        if ( empty( $post ) || !is_post_publicly_viewable( $post ) )
            return;

        $target = NULL;
        if ( preg_match( '/<!--\s+(https?:\/\/\S+|\d+)\s+-->/', $post->post_content, $m ) )
            $target = $m[1];

        if ( $target && is_numeric( $target ) ) {
            $post = get_post( absint( $target ) );
            if ( $post && is_post_publicly_viewable( $post ) )
                $target = get_permalink( $post );
        }

        if ( $target ) {
            wp_redirect( $target ?: site_url() );
            die;
        }
    }
}
