<?php

namespace ReneSeindal;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


/************************************************************************
 *
 * Send an email when a scheduled post is published
 *
 ************************************************************************/

trait PluginNotifyOwnerScheduledPublish {
   function do_future_to_publish_action_notify_owner_scheduled_publish( $post ) {
        $user = get_userdata( $post->post_author );
        if ( false === $user )
            return;

        $message = [];

        $message[] = $post->post_title;
        $message[] = '';

        $excerpt = $post->post_excerpt;
        if ( empty( $excerpt ) )
            $excerpt = __( 'Published post has no excerpt', 'rs-base-plugin' );

        $message[] = $excerpt;
        $message[] = '';

        $taxonomies = get_taxonomies( [
            'public' => 1,
            'show_ui' => 1,
            'hierarchical' => 0,
        ], 'objects' );

        foreach ( $taxonomies as $taxonomy ) {
            if ( in_array( $post->post_type, $taxonomy->object_type ) ) {
                $tags = get_the_terms( $post, $taxonomy->name );

                if ( empty( $tags ) )
                    continue;

                $slugs = [];
                foreach ( $tags as $tag ) {
                    $tagname = $tag->name;

                    // Remove parenthesised suffix
                    if ( preg_match( '/(.*?)\(.*\)$/', $tagname, $m ) ) {
                        $tagname = $m[1];
                    }

                    // Separate multiple aliases
                    $parts = explode( ' aka ', $tagname );

                    foreach ( $parts as $slug ) {
                        $slug = join( '', array_map( 'ucfirst', preg_split( '/[^[:alpha:]]+/u', trim( $slug ) ) ) );
                        $slugs[] = '#' . $slug;
                    }
                }
                $message[] = join( ' ', $slugs );
            }
        }

        $message[] = '';
        $message[] = get_permalink( $post );

        wp_mail( $user->user_email, __( 'Published: ', 'rs-base-plugin' ) . $post->post_title, join(PHP_EOL, $message));
    }
}
