<?php

namespace ReneSeindal;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


/************************************************************
 *
 * Yoast SEO - remove admin post list filters
 *
 ************************************************************/

trait PluginBaseYoastSeo {
    protected $admin_init_yoast_seo_callback_priority = 999;

    function do_admin_init_action_yoast_seo() {
        global $wpseo_meta_columns;
        if ($wpseo_meta_columns) {
            remove_action( 'restrict_manage_posts', [ $wpseo_meta_columns, 'posts_filter_dropdown' ] );
            remove_action( 'restrict_manage_posts', [ $wpseo_meta_columns, 'posts_filter_dropdown_readability' ] );
        }

        if ( class_exists( 'Yoast_Notification_Center' ) ) {
            $yoast_nc = \Yoast_Notification_Center::get();
            remove_action( 'admin_notices', array( $yoast_nc, 'display_notifications' ) );
            remove_action( 'all_admin_notices', array( $yoast_nc, 'display_notifications' ) );
        }
    }

    protected $wpseo_opengraph_image_callback_arguments = 2;

    function do_wpseo_opengraph_image_filter( $url, $obj ) {
        if ( !empty( $obj->model->open_graph_image_id ) )
            return get_permalink( $obj->model->open_graph_image_id );

        if ( !empty( $obj->model->twitter_image ) )
            return $obj->model->twitter_image;

        return $url;
    }
}
