<?php

namespace ReneSeindal;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/************************************************************************
 *
 *	Dashicons codepoints
 *
 ************************************************************************/

class DashIcons {
    static function lookup( $icon ) {
        if ( ! str_starts_with( $icon, 'dashicons-' ) )
            $icon = 'dashicons-' . $icon;

        return self::$dashicons[$icon] ?? NULL;
    }

    static protected $dashicons = [
        'dashicons-menu' => 62259,
        'dashicons-admin-site' => 62233,
        'dashicons-dashboard' => 61990,
        'dashicons-admin-media' => 61700,
        'dashicons-admin-page' => 61701,
        'dashicons-admin-comments' => 61697,
        'dashicons-admin-appearance' => 61696,
        'dashicons-admin-plugins' => 61702,
        'dashicons-admin-users' => 61712,
        'dashicons-admin-tools' => 61703,
        'dashicons-admin-settings' => 61704,
        'dashicons-admin-network' => 61714,
        'dashicons-admin-generic' => 61713,
        'dashicons-admin-home' => 61698,
        'dashicons-admin-collapse' => 61768,
        'dashicons-filter' => 62774,
        'dashicons-admin-customizer' => 62784,
        'dashicons-admin-multisite' => 62785,
        'dashicons-admin-links' => 61699,
        'dashicons-admin-post' => 61705,
        'dashicons-format-image' => 61736,
        'dashicons-format-gallery' => 61793,
        'dashicons-format-audio' => 61735,
        'dashicons-format-video' => 61734,
        'dashicons-format-chat' => 61733,
        'dashicons-format-status' => 61744,
        'dashicons-format-aside' => 61731,
        'dashicons-format-quote' => 61730,
        'dashicons-welcome-write-blog' => 61721,
        'dashicons-welcome-add-page' => 61747,
        'dashicons-welcome-view-site' => 61717,
        'dashicons-welcome-widgets-menus' => 61718,
        'dashicons-welcome-comments' => 61719,
        'dashicons-welcome-learn-more' => 61720,
        'dashicons-image-crop' => 61797,
        'dashicons-image-rotate' => 62769,
        'dashicons-image-rotate-left' => 61798,
        'dashicons-image-rotate-right' => 61799,
        'dashicons-image-flip-vertical' => 61800,
        'dashicons-image-flip-horizontal' => 61801,
        'dashicons-image-filter' => 62771,
        'dashicons-undo' => 61809,
        'dashicons-redo' => 61810,
        'dashicons-editor-bold' => 61952,
        'dashicons-editor-italic' => 61953,
        'dashicons-editor-ul' => 61955,
        'dashicons-editor-ol' => 61956,
        'dashicons-editor-quote' => 61957,
        'dashicons-editor-alignleft' => 61958,
        'dashicons-editor-aligncenter' => 61959,
        'dashicons-editor-alignright' => 61960,
        'dashicons-editor-insertmore' => 61961,
        'dashicons-editor-spellcheck' => 61968,
        'dashicons-editor-expand' => 61969,
        'dashicons-editor-contract' => 62726,
        'dashicons-editor-kitchensink' => 61970,
        'dashicons-editor-underline' => 61971,
        'dashicons-editor-justify' => 61972,
        'dashicons-editor-textcolor' => 61973,
        'dashicons-editor-paste-word' => 61974,
        'dashicons-editor-paste-text' => 61975,
        'dashicons-editor-removeformatting' => 61976,
        'dashicons-editor-video' => 61977,
        'dashicons-editor-customchar' => 61984,
        'dashicons-editor-outdent' => 61985,
        'dashicons-editor-indent' => 61986,
        'dashicons-editor-help' => 61987,
        'dashicons-editor-strikethrough' => 61988,
        'dashicons-editor-unlink' => 61989,
        'dashicons-editor-rtl' => 62240,
        'dashicons-editor-break' => 62580,
        'dashicons-editor-code' => 62581,
        'dashicons-editor-code-duplicate' => 62612,
        'dashicons-editor-paragraph' => 62582,
        'dashicons-editor-table' => 62773,
        'dashicons-align-left' => 61749,
        'dashicons-align-right' => 61750,
        'dashicons-align-center' => 61748,
        'dashicons-align-none' => 61752,
        'dashicons-lock' => 61792,
        'dashicons-lock-duplicate' => 62229,
        'dashicons-unlock' => 62760,
        'dashicons-calendar' => 61765,
        'dashicons-calendar-alt' => 62728,
        'dashicons-visibility' => 61815,
        'dashicons-hidden' => 62768,
        'dashicons-post-status' => 61811,
        'dashicons-edit' => 62564,
        'dashicons-edit-large' => 62247,
        'dashicons-sticky' => 62775,
        'dashicons-external' => 62724,
        'dashicons-arrow-up' => 61762,
        'dashicons-arrow-up-duplicate' => 61763,
        'dashicons-arrow-down' => 61760,
        'dashicons-arrow-left' => 61761,
        'dashicons-arrow-right' => 61753,
        'dashicons-arrow-up-alt' => 62274,
        'dashicons-arrow-down-alt' => 62278,
        'dashicons-arrow-left-alt' => 62272,
        'dashicons-arrow-right-alt' => 62276,
        'dashicons-arrow-up-alt2' => 62275,
        'dashicons-arrow-down-alt2' => 62279,
        'dashicons-arrow-left-alt2' => 62273,
        'dashicons-arrow-right-alt2' => 62277,
        'dashicons-leftright' => 61993,
        'dashicons-sort' => 61782,
        'dashicons-randomize' => 62723,
        'dashicons-list-view' => 61795,
        'dashicons-excerpt-view' => 61796,
        'dashicons-grid-view' => 62729,
        'dashicons-move' => 62789,
        'dashicons-hammer' => 62216,
        'dashicons-art' => 62217,
        'dashicons-migrate' => 62224,
        'dashicons-performance' => 62225,
        'dashicons-universal-access' => 62595,
        'dashicons-universal-access-alt' => 62727,
        'dashicons-tickets' => 62598,
        'dashicons-nametag' => 62596,
        'dashicons-clipboard' => 62593,
        'dashicons-heart' => 62599,
        'dashicons-megaphone' => 62600,
        'dashicons-schedule' => 62601,
        'dashicons-wordpress' => 61728,
        'dashicons-wordpress-alt' => 62244,
        'dashicons-pressthis' => 61783,
        'dashicons-update' => 62563,
        'dashicons-screenoptions' => 61824,
        'dashicons-cart' => 61812,
        'dashicons-feedback' => 61813,
        'dashicons-translation' => 62246,
        'dashicons-tag' => 62243,
        'dashicons-category' => 62232,
        'dashicons-archive' => 62592,
        'dashicons-tagcloud' => 62585,
        'dashicons-text' => 62584,
        'dashicons-media-archive' => 62721,
        'dashicons-media-audio' => 62720,
        'dashicons-media-code' => 62617,
        'dashicons-media-default' => 62616,
        'dashicons-media-document' => 62615,
        'dashicons-media-interactive' => 62614,
        'dashicons-media-spreadsheet' => 62613,
        'dashicons-media-text' => 62609,
        'dashicons-media-video' => 62608,
        'dashicons-playlist-audio' => 62610,
        'dashicons-playlist-video' => 62611,
        'dashicons-controls-play' => 62754,
        'dashicons-controls-pause' => 62755,
        'dashicons-controls-forward' => 62745,
        'dashicons-controls-skipforward' => 62743,
        'dashicons-controls-back' => 62744,
        'dashicons-controls-skipback' => 62742,
        'dashicons-controls-repeat' => 62741,
        'dashicons-controls-volumeon' => 62753,
        'dashicons-controls-volumeoff' => 62752,
        'dashicons-yes' => 61767,
        'dashicons-no' => 61784,
        'dashicons-no-alt' => 62261,
        'dashicons-plus' => 61746,
        'dashicons-plus-alt' => 62722,
        'dashicons-plus-alt2' => 62787,
        'dashicons-minus' => 62560,
        'dashicons-dismiss' => 61779,
        'dashicons-marker' => 61785,
        'dashicons-star-filled' => 61781,
        'dashicons-star-half' => 62553,
        'dashicons-star-empty' => 61780,
        'dashicons-flag' => 61991,
        'dashicons-info' => 62280,
        'dashicons-warning' => 62772,
        'dashicons-share' => 62007,
        'dashicons-share1' => 62007,
        'dashicons-share-alt' => 62016,
        'dashicons-share-alt2' => 62018,
        'dashicons-twitter' => 62209,
        'dashicons-rss' => 62211,
        'dashicons-email' => 62565,
        'dashicons-email-alt' => 62566,
        'dashicons-facebook' => 62212,
        'dashicons-facebook-alt' => 62213,
        'dashicons-networking' => 62245,
        'dashicons-googleplus' => 62562,
        'dashicons-location' => 62000,
        'dashicons-location-alt' => 62001,
        'dashicons-camera' => 62214,
        'dashicons-images-alt' => 62002,
        'dashicons-images-alt2' => 62003,
        'dashicons-video-alt' => 62004,
        'dashicons-video-alt2' => 62005,
        'dashicons-video-alt3' => 62006,
        'dashicons-vault' => 61816,
        'dashicons-shield' => 62258,
        'dashicons-shield-alt' => 62260,
        'dashicons-sos' => 62568,
        'dashicons-search' => 61817,
        'dashicons-slides' => 61825,
        'dashicons-analytics' => 61827,
        'dashicons-chart-pie' => 61828,
        'dashicons-chart-bar' => 61829,
        'dashicons-chart-line' => 62008,
        'dashicons-chart-area' => 62009,
        'dashicons-groups' => 62215,
        'dashicons-businessman' => 62264,
        'dashicons-id' => 62262,
        'dashicons-id-alt' => 62263,
        'dashicons-products' => 62226,
        'dashicons-awards' => 62227,
        'dashicons-forms' => 62228,
        'dashicons-testimonial' => 62579,
        'dashicons-portfolio' => 62242,
        'dashicons-book' => 62256,
        'dashicons-book-alt' => 62257,
        'dashicons-download' => 62230,
        'dashicons-upload' => 62231,
        'dashicons-backup' => 62241,
        'dashicons-clock' => 62569,
        'dashicons-lightbulb' => 62265,
        'dashicons-microphone' => 62594,
        'dashicons-desktop' => 62578,
        'dashicons-laptop' => 62791,
        'dashicons-tablet' => 62577,
        'dashicons-smartphone' => 62576,
        'dashicons-phone' => 62757,
        'dashicons-smiley' => 62248,
        'dashicons-index-card' => 62736,
        'dashicons-carrot' => 62737,
        'dashicons-building' => 62738,
        'dashicons-store' => 62739,
        'dashicons-album' => 62740,
        'dashicons-palmtree' => 62759,
        'dashicons-tickets-alt' => 62756,
        'dashicons-money' => 62758,
        'dashicons-thumbs-up' => 62761,
        'dashicons-thumbs-down' => 62786,
        'dashicons-layout' => 62776,
        'dashicons-paperclip' => 62790,
        'dashicons-email-alt2' => 62567,
        'dashicons-menu-alt' => 61992,
        'dashicons-trash' => 61826,
        'dashicons-heading' => 61710,
        'dashicons-insert' => 61711,
        'dashicons-align-full-width' => 61716,
        'dashicons-button' => 61722,
        'dashicons-align-wide' => 61723,
        'dashicons-ellipsis' => 61724,
        'dashicons-buddicons-activity' => 62546,
        'dashicons-buddicons-buddypress-logo' => 62536,
        'dashicons-buddicons-community' => 62547,
        'dashicons-buddicons-forums' => 62537,
        'dashicons-buddicons-friends' => 62548,
        'dashicons-buddicons-groups' => 62550,
        'dashicons-buddicons-pm' => 62551,
        'dashicons-buddicons-replies' => 62545,
        'dashicons-buddicons-topics' => 62544,
        'dashicons-buddicons-tracking' => 62549,
        'dashicons-admin-site-alt' => 61725,
        'dashicons-admin-site-alt2' => 61726,
        'dashicons-admin-site-alt3' => 61727,
        'dashicons-rest-api' => 61732,
        'dashicons-yes-alt' => 61738,
        'dashicons-buddicons-bbpress-logo' => 62583,
        'dashicons-tide' => 61709,
        'dashicons-editor-ol-rtl' => 61740,
        'dashicons-instagram' => 61741,
        'dashicons-businessperson' => 61742,
        'dashicons-businesswoman' => 61743,
        'dashicons-color-picker' => 61745,
        'dashicons-camera-alt' => 61737,
        'dashicons-editor-ltr' => 61708,
        'dashicons-cloud' => 61814,
        'dashicons-twitter-alt' => 62210,
        'dashicons-menu-alt2' => 62249,
        'dashicons-menu-alt3' => 62281,
        'dashicons-plugins-checked' => 62597,
        'dashicons-text-page' => 61729,
        'dashicons-update-alt' => 61715,
        'dashicons-code-standards' => 61754,
        'dashicons-align-pull-left' => 61706,
        'dashicons-align-pull-right' => 61707,
        'dashicons-block-default' => 61739,
        'dashicons-cloud-saved' => 61751,
        'dashicons-cloud-upload' => 61755,
        'dashicons-columns' => 61756,
        'dashicons-cover-image' => 61757,
        'dashicons-embed-audio' => 61758,
        'dashicons-embed-generic' => 61759,
        'dashicons-embed-photo' => 61764,
        'dashicons-embed-post' => 61766,
        'dashicons-embed-video' => 61769,
        'dashicons-exit' => 61770,
        'dashicons-html' => 61771,
        'dashicons-info-outline' => 61772,
        'dashicons-insert-after' => 61773,
        'dashicons-insert-before' => 61774,
        'dashicons-remove' => 61775,
        'dashicons-shortcode' => 61776,
        'dashicons-table-col-after' => 61777,
        'dashicons-table-col-before' => 61778,
        'dashicons-table-col-delete' => 61786,
        'dashicons-table-row-after' => 61787,
        'dashicons-table-row-before' => 61788,
        'dashicons-table-row-delete' => 61789,
        'dashicons-saved' => 61790,
        'dashicons-airplane' => 61791,
        'dashicons-amazon' => 61794,
        'dashicons-bank' => 61802,
        'dashicons-beer' => 61804,
        'dashicons-bell' => 61805,
        'dashicons-calculator' => 61806,
        'dashicons-coffee' => 61807,
        'dashicons-database-add' => 61808,
        'dashicons-database-export' => 61818,
        'dashicons-database-import' => 61819,
        'dashicons-database-remove' => 61820,
        'dashicons-database-view' => 61821,
        'dashicons-database' => 61822,
        'dashicons-drumstick' => 61823,
        'dashicons-edit-page' => 61830,
        'dashicons-food' => 61831,
        'dashicons-fullscreen-alt' => 61832,
        'dashicons-fullscreen-exit-alt' => 61833,
        'dashicons-games' => 61834,
        'dashicons-google' => 61835,
        'dashicons-hourglass' => 61836,
        'dashicons-linkedin' => 61837,
        'dashicons-money-alt' => 61838,
        'dashicons-open-folder' => 61839,
        'dashicons-pdf' => 61840,
        'dashicons-pets' => 61841,
        'dashicons-pinterest' => 61842,
        'dashicons-printer' => 61843,
        'dashicons-privacy' => 61844,
        'dashicons-reddit' => 61845,
        'dashicons-spotify' => 61846,
        'dashicons-superhero-alt' => 61847,
        'dashicons-superhero' => 61848,
        'dashicons-twitch' => 61849,
        'dashicons-whatsapp' => 61850,
        'dashicons-youtube' => 61851,
        'dashicons-car' => 61803,
        'dashicons-podio' => 61852,
        'dashicons-xing' => 61853,
    ];
}
